//using System.Collections.Generic;
//using System.Threading.Tasks;
//using UnityEngine;
//using UnityEngine.Networking;

//public class RouteManager : MonoBehaviour
//{
//    public static RouteManager Instance;

//    [Header("API Settings")]
//    public string baseUrl = "https://api.arassistant.nl/";

//    private void Awake()
//    {
//        if (Instance != null && Instance != this)
//        {
//            Destroy(gameObject);
//            return;
//        }
//        Instance = this;
//    }

//    public async Task<List<string>> GetPathToTargetNode(string targetNodeId)
//    {
//        Vector3 currentPosition = LocationTracker.Instance.GetCurrentPosition();

//        string url = $"{baseUrl}/path?fromX={currentPosition.x}&fromY={currentPosition.y}&fromZ={currentPosition.z}&toId={targetNodeId}";

//        using UnityWebRequest request = UnityWebRequest.Get(url);
//        request.downloadHandler = new DownloadHandlerBuffer();

//        await request.SendWebRequest();

//        if (request.result != UnityWebRequest.Result.Success)
//        {
//            Debug.LogError($"Path request failed: {request.error}");
//            return null;
//        }

//        string jsonResponse = request.downloadHandler.text;
//        PathResponse response = JsonUtility.FromJson<PathResponse>(jsonResponse);
//        return response.nodeIds;
//    }


//    [System.Serializable]
//    public class PathResponse
//    {
//        public List<string> nodeIds;
//    }
//}




////using System.Collections.Generic;
////using TMPro;
////using Unity.Android.Gradle.Manifest;
////using UnityEngine;

////public class RouteManager : MonoBehaviour
////{
////    public HTTPClient httpClient;

////    [Header("Request properties")]
////    public string graphId;
////    [Space(10)]
////    public string PathfindingFrom;
////    public string PathfindingTo;

////    [Header("Settings")]
////    public bool drawGraph;

////    [Header("Scene props")]
////    public GameObject nodePrefab;
////    public Material lineMaterial;
////    public TextMeshProUGUI text;

////    // Optionally, you can expose these as public fields if you want to set them in the Inspector:
////    [Header("Mapping properties")]
////    public Vector3 targetMin;
////    public Vector3 targetMax;

////    private Dictionary<string, GameObject> nodeObjects = new();
////    private GameObject graphParent;

////    // Method to send a GET request to the specified URL
////    public void LoadGraph()
////    {
////        if (httpClient != null || graphId != null)
////        {
////            StartCoroutine(httpClient.GetRequest($"http://localhost:3000/navigation/graph/{graphId}", BuildGraph, HandleGraphError));
////        }
////        else
////        {
////            text.text = "HTTPClient or GraphID is not set. Cannot send GET request.";
////            Debug.LogError("HTTPClient or GraphID is not set. Cannot send GET request.");
////        }
////    }

////    private void HandleGraphError(string error)
////    {
////        Debug.Log(error);
////    }

////    private void BuildGraph(string data)
////    {
////        // Parse data
////        Graph graph = JsonUtility.FromJson<Graph>(data);

////        Debug.Log(graph.nodes[1].label);

////        if (drawGraph)
////        {
////            DrawEntireGraph(graph);
////        }

////    }

////    private void DrawEntireGraph(Graph graph)
////    {
////        if (graphParent != null) Destroy(graphParent);
////        graphParent = new GameObject("Graph");
////        nodeObjects.Clear();

////        // Determine bounds
////        Vector3 originalMin = new Vector3(float.MaxValue, float.MaxValue, float.MaxValue);
////        Vector3 originalMax = new Vector3(float.MinValue, float.MinValue, float.MinValue);

////        foreach (var node in graph.nodes)
////        {
////            originalMin = Vector3.Min(originalMin, new Vector3(node.x, node.y, node.z));
////            originalMax = Vector3.Max(originalMax, new Vector3(node.x, node.y, node.z));
////        }

////        Vector3 originalSize = originalMax - originalMin;
////        Vector3 targetSize = targetMax - targetMin;

////        // Instantiate nodes
////        foreach (var node in graph.nodes)
////        {
////            Vector3 original = new Vector3(node.x, node.y, node.z);
////            Vector3 normalized = new Vector3(
////                (original.x - originalMin.x) / originalSize.x,
////                (original.y - originalMin.y) / originalSize.y,
////                (original.z - originalMin.z) / originalSize.z
////            );

////            Vector3 mapped = new Vector3(
////                targetMin.x + normalized.x * targetSize.x,
////                targetMin.y + normalized.y * targetSize.y,
////                targetMin.z + normalized.z * targetSize.z
////            );

////            GameObject nodeGO = Instantiate(nodePrefab, mapped, Quaternion.identity, graphParent.transform);
////            nodeGO.name = $"Node_{node.id}";
////            nodeObjects[node.id] = nodeGO;
////        }

////        Debug.Log($"Built graph with {graph.nodes.Count} nodes.");
////    }

////}
